$(function()
{

    /**
     * When building your forms, you MUST make sure your form has an ID, and that it's unique
     * on the application.
     *
     * Ie, don't call all forms 'id="form"', even if they are on seperate pages.
     */

    /*
     * Attach to a form with default settings
     */
    $('#regform').sayt();


    /*
     * Attach to a form with custom settings
     *
     * Autosave disabled (Must use manual save to save anything)
     * Autorecover disabled (Must use a manual recover to recover anything)
     * Days 7 (Keeps the save cookie for 7 days)
     */
    $('#regform').sayt({'autosave': true, 'autorecover': true, 'days': 1});


    /*
     * Check to see if a form has a save
     */
    if($('#regform').sayt({'checksaveexists': true}) == true)
    {
        console.log('Form has an existing save cookie.');
    }


    /*
     * Perform a manual save
     */
    $('#forms_save_button').click(function()
    {
        $('#regform').sayt({'savenow': true});

        console.log('Form data has been saved.');
        return false;
    });


    /*
     * Perform a manual recover
     */
    $('#forms_recover_button').click(function()
    {
        $('#regform').sayt({'recover': true});

        console.log('Form data has been recovered.');
        return false;
    });


    /*
     * To erase a forms cookie
     */
    $('#forms_delete_save_button').click(function()
    {
        $('#regform').sayt({'erase': true});

        console.log('Form cookie was deleted.');
        return false;
    });

});


function regclick() {

    $.ajax({
            type: "POST",
            url: "regformprocess.php",
            cache : false,
            data: $('form#regform').serialize(),
            dataType: 'html',

            success: function (msg) {
                if (msg=="Please submit the form again. (Google suspects you're a bot. Sorry)"){
                    $("#errorDiv").html(msg);
                } else {
                    $("#thanks").html(msg);
                }


            },
            error: function () {

                $("#rcFeedback").html(msg);
            }
        }
    );
}


function SelectRadioButton(name, value) {

    $("input[name='" + name + "'][value='" + value + "']").prop('checked', true);
    $(".block-for-form").removeClass("selected");
    $("#plan" + value).parent().addClass("selected");

    if (name == 'plan') {
        console.log ("Oh. I see plan clicked");
        if (value==3){
            $('#planDescription').show('fast');
            $('#theDesc').attr('required','');
        } else {
            $('#planDescription').hide('fast');
            $('#theDesc').removeAttr('required');
        }
    }



}

$(document).ready (function (){

    $(".moving").click(function (){
        $('html, body').animate({
            scrollTop: $("#"+$(this).attr('data')).offset().top
        }, 500);
        return false;
    });


$("input[name=plan]").change(function() {
    $(".block-for-form").removeClass("selected");
    $(this).parent().addClass("selected");

    if ($(this).attr('name') == 'plan') {
        console.log ("Oh. I see plan clicked");
        if ($(this).attr('value') == 3) {
            $('#planDescription').show('fast');
            $('#theDesc').attr('required','');
        } else {
            $('#planDescription').hide('fast');
            $('#theDesc').removeAttr('required');
        }
    }
    console.log ("chosen");
});



});