import { Link } from 'wouter';
import { Button } from "@/components/ui/button";

export function CTASection() {
  return (
    <section className="py-16 bg-primary-600 px-4 sm:px-6 lg:px-8">
      <div className="container mx-auto">
        <div className="max-w-3xl mx-auto text-center">
          <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
            Ready to Optimize Your Service Desk?
          </h2>
          <p className="text-lg text-primary-100 mb-8">
            Schedule a free consultation to discuss how we can help you implement the perfect service desk solution.
          </p>
          <Button 
            asChild
            size="lg" 
            className="bg-white text-primary-600 hover:bg-primary-50 px-8 py-4 text-lg font-bold"
          >
            <Link href="#contact">Get Started Today</Link>
          </Button>
        </div>
      </div>
    </section>
  );
}
