import { Card } from "@/components/ui/card";

export interface TestimonialCardProps {
  quote: string;
  author: string;
  position: string;
  company: string;
  initials: string;
  rating: number;
  bgColor: string;
  textColor: string;
}

export function TestimonialCard({
  quote,
  author,
  position,
  company,
  initials,
  rating,
  bgColor,
  textColor
}: TestimonialCardProps) {
  return (
    <Card className="bg-slate-50 p-6 rounded-xl shadow-sm">
      <div className="flex items-center mb-4">
        <div className="text-accent">
          {Array.from({ length: 5 }).map((_, i) => (
            <i key={i} className={i < rating ? "fas fa-star" : "fas fa-star-half-alt"}></i>
          ))}
        </div>
      </div>
      <blockquote className="text-slate-700 mb-6">
        "{quote}"
      </blockquote>
      <div className="flex items-center">
        <div className={`w-12 h-12 ${bgColor} rounded-full flex items-center justify-center mr-4`}>
          <span className={`${textColor} font-bold`}>{initials}</span>
        </div>
        <div>
          <h4 className="font-bold">{author}</h4>
          <p className="text-sm text-slate-500">{position}, {company}</p>
        </div>
      </div>
    </Card>
  );
}
