export function ProcessSection() {
  const processSteps = [
    {
      icon: "fas fa-clipboard-list",
      title: "1. Assessment",
      description: "We analyze your requirements and current processes to create a tailored implementation plan."
    },
    {
      icon: "fas fa-pencil-ruler",
      title: "2. Design",
      description: "We design custom workflows, forms, and automations that match your business needs."
    },
    {
      icon: "fas fa-tools",
      title: "3. Implementation",
      description: "We configure your chosen platform according to the approved design specifications."
    },
    {
      icon: "fas fa-graduation-cap",
      title: "4. Training & Support",
      description: "We provide comprehensive training and ongoing support to ensure successful adoption."
    }
  ];

  return (
    <section id="process" className="py-20 bg-slate-50 px-4 sm:px-6 lg:px-8">
      <div className="container mx-auto">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Implementation Process</h2>
          <p className="text-lg text-slate-600 max-w-2xl mx-auto">
            We follow a structured approach to ensure successful configuration and implementation.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          {processSteps.map((step, index) => (
            <div key={index} className="text-center">
              <div className="w-16 h-16 bg-primary-600 text-white rounded-full flex items-center justify-center mx-auto mb-4">
                <i className={`${step.icon} text-2xl`}></i>
              </div>
              <h3 className="text-xl font-bold mb-2">{step.title}</h3>
              <p className="text-slate-600">{step.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
