import { Link } from 'wouter';
import { Card } from "@/components/ui/card";

export interface ServiceCardProps {
  title: string;
  description: string;
  icon: string;
  features: string[];
  colorClass: string;
  borderColorClass: string;
  iconBgClass: string;
  iconColorClass: string;
  checkIconColorClass: string;
  learnMoreLink: string;
}

export function ServiceCard({
  title,
  description,
  icon,
  features,
  colorClass,
  borderColorClass,
  iconBgClass,
  iconColorClass,
  checkIconColorClass,
  learnMoreLink,
}: ServiceCardProps) {
  return (
    <Card className="service-card bg-white rounded-xl shadow-md overflow-hidden">
      <div className={`h-2 ${borderColorClass}`}></div>
      <div className="p-6">
        <div className={`w-14 h-14 ${iconBgClass} ${iconColorClass} rounded-lg flex items-center justify-center mb-4`}>
          <i className={`${icon} text-2xl`}></i>
        </div>
        <h3 className="text-2xl font-bold mb-3">{title}</h3>
        <p className="text-slate-600 mb-4">{description}</p>
        <ul className="space-y-2 mb-6">
          {features.map((feature, index) => (
            <li key={index} className="flex items-start">
              <i className={`fas fa-check-circle ${checkIconColorClass} mt-1 mr-2`}></i>
              <span>{feature}</span>
            </li>
          ))}
        </ul>
        <Link href={learnMoreLink} className={`inline-block ${colorClass} font-medium hover:${colorClass}/90`}>
          Learn more <i className="fas fa-arrow-right ml-1"></i>
        </Link>
      </div>
    </Card>
  );
}
