import { AspectRatio } from "@/components/ui/aspect-ratio";

export function WhyChooseUs() {
  return (
    <section className="py-20 bg-white px-4 sm:px-6 lg:px-8">
      <div className="container mx-auto">
        <div className="grid md:grid-cols-2 gap-12 items-center">
          <div>
            <h2 className="text-3xl md:text-4xl font-bold mb-6">
              Why Choose Our Configuration Services?
            </h2>
            <p className="text-lg text-slate-600 mb-8">
              We bring expertise, efficiency, and innovation to your service desk implementation, 
              ensuring you get the most value from your platform investment.
            </p>
            
            <div className="space-y-6">
              <div className="flex">
                <div className="flex-shrink-0 mr-4">
                  <div className="w-12 h-12 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center">
                    <i className="fas fa-users-cog text-xl"></i>
                  </div>
                </div>
                <div>
                  <h3 className="text-xl font-bold mb-2">Expert Consultants</h3>
                  <p className="text-slate-600">
                    Our team has certified expertise across Jira Service Management, GLPI, and ESMP platforms.
                  </p>
                </div>
              </div>
              
              <div className="flex">
                <div className="flex-shrink-0 mr-4">
                  <div className="w-12 h-12 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center">
                    <i className="fas fa-cogs text-xl"></i>
                  </div>
                </div>
                <div>
                  <h3 className="text-xl font-bold mb-2">Tailored Solutions</h3>
                  <p className="text-slate-600">
                    We customize configurations to match your organization's unique workflows and requirements.
                  </p>
                </div>
              </div>
              
              <div className="flex">
                <div className="flex-shrink-0 mr-4">
                  <div className="w-12 h-12 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center">
                    <i className="fas fa-chart-line text-xl"></i>
                  </div>
                </div>
                <div>
                  <h3 className="text-xl font-bold mb-2">Ongoing Support</h3>
                  <p className="text-slate-600">
                    We provide continuous assistance and optimization to ensure your service desk evolves with your needs.
                  </p>
                </div>
              </div>
            </div>
          </div>
          
          <div className="relative rounded-xl overflow-hidden shadow-lg">
            <AspectRatio ratio={4/3}>
              <div className="absolute inset-0 bg-gradient-to-br from-primary-500/50 to-secondary-600/50 mix-blend-multiply"></div>
              <div className="h-full w-full bg-[url('https://images.unsplash.com/photo-1581091226825-a6a2a5aee158?ixlib=rb-1.2.1&auto=format&fit=crop&w=600&q=80')] bg-cover bg-center"></div>
            </AspectRatio>
          </div>
        </div>
      </div>
    </section>
  );
}
