import { Header } from "@/components/layout/header";
import { Footer } from "@/components/layout/footer";
import { Button } from "@/components/ui/button";
import { ContactSection } from "@/components/ui/contact-section";
import { CTASection } from "@/components/ui/cta-section";
import { Link } from "wouter";

export default function GLPIPage() {
  return (
    <>
      <Header />
      <main>
        {/* Hero Section */}
        <section className="pt-28 pb-20 px-4 sm:px-6 lg:px-8 bg-gradient-to-r from-secondary-600 to-secondary-700 text-white">
          <div className="container mx-auto">
            <div className="grid md:grid-cols-2 gap-12 items-center">
              <div>
                <h1 className="text-4xl md:text-5xl font-bold mb-6">GLPI Configuration Services</h1>
                <p className="text-xl text-secondary-50 mb-8">
                  Implement and customize GLPI to create a comprehensive IT asset management and 
                  service desk solution tailored to your organization's needs.
                </p>
                <Button 
                  asChild
                  size="lg" 
                  className="bg-white text-secondary-600 hover:bg-secondary-50"
                >
                  <Link href="#glpi-features">Explore Features</Link>
                </Button>
              </div>
              
              <div className="flex justify-center">
                <div className="w-full max-w-lg p-6 bg-white rounded-lg shadow-xl">
                  <div className="flex items-center mb-6">
                    <i className="fas fa-ticket-alt text-4xl text-secondary-600 mr-3"></i>
                    <h3 className="text-2xl font-bold text-slate-900">GLPI Platform</h3>
                  </div>
                  <div className="space-y-4 text-slate-800">
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-secondary-600 mt-1 mr-2"></i>
                      <p>Open-source IT Service Management</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-secondary-600 mt-1 mr-2"></i>
                      <p>Comprehensive asset management</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-secondary-600 mt-1 mr-2"></i>
                      <p>Flexible helpdesk capabilities</p>
                    </div>
                    <div className="flex items-start">
                      <i className="fas fa-check-circle text-secondary-600 mt-1 mr-2"></i>
                      <p>Extendable plugin architecture</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        
        {/* Features Section */}
        <section id="glpi-features" className="py-20 bg-white px-4 sm:px-6 lg:px-8">
          <div className="container mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-3xl md:text-4xl font-bold mb-4">GLPI Configuration Features</h2>
              <p className="text-lg text-slate-600 max-w-2xl mx-auto">
                Our expert team sets up and customizes GLPI to provide a comprehensive IT asset and 
                service management solution for your organization.
              </p>
            </div>
            
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-secondary-100 text-secondary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-laptop text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Asset Management</h3>
                <p className="text-slate-600">
                  Set up comprehensive tracking and management of all your IT assets, including hardware, 
                  software, and network equipment.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-secondary-100 text-secondary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-headset text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Helpdesk Configuration</h3>
                <p className="text-slate-600">
                  Configure ticketing system with custom categories, priorities, and escalation rules 
                  to meet your support workflow requirements.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-secondary-100 text-secondary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-plug text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Plugin Integration</h3>
                <p className="text-slate-600">
                  Install and configure essential plugins to extend GLPI functionality for your specific needs.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-secondary-100 text-secondary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-users-cog text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">User Management</h3>
                <p className="text-slate-600">
                  Set up user groups, permissions, and authentication methods including LDAP/Active Directory integration.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-secondary-100 text-secondary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-chart-bar text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Custom Dashboards</h3>
                <p className="text-slate-600">
                  Create custom dashboards and reports to provide visibility into your IT assets, 
                  service desk performance, and resource utilization.
                </p>
              </div>
              
              <div className="bg-slate-50 p-6 rounded-xl shadow-sm">
                <div className="w-14 h-14 bg-secondary-100 text-secondary-600 rounded-lg flex items-center justify-center mb-4">
                  <i className="fas fa-sync-alt text-2xl"></i>
                </div>
                <h3 className="text-xl font-bold mb-3">Automation</h3>
                <p className="text-slate-600">
                  Configure automated asset discovery, ticket routing, notifications, and escalations to streamline operations.
                </p>
              </div>
            </div>
          </div>
        </section>
        
        {/* Benefits Section */}
        <section className="py-20 bg-slate-50 px-4 sm:px-6 lg:px-8">
          <div className="container mx-auto">
            <div className="text-center mb-16">
              <h2 className="text-3xl md:text-4xl font-bold mb-4">Benefits of GLPI Configuration</h2>
              <p className="text-lg text-slate-600 max-w-2xl mx-auto">
                A properly configured GLPI platform delivers multiple benefits to your organization's IT operations.
              </p>
            </div>
            
            <div className="grid md:grid-cols-2 gap-12 items-center">
              <div className="order-2 md:order-1">
                <div className="space-y-6">
                  <div className="flex">
                    <div className="flex-shrink-0 mr-4">
                      <div className="w-12 h-12 bg-secondary-100 text-secondary-600 rounded-full flex items-center justify-center">
                        <i className="fas fa-dollar-sign text-xl"></i>
                      </div>
                    </div>
                    <div>
                      <h3 className="text-xl font-bold mb-2">Cost Reduction</h3>
                      <p className="text-slate-600">
                        Optimize IT asset lifecycle management and reduce support costs through efficient service desk operations.
                      </p>
                    </div>
                  </div>
                  
                  <div className="flex">
                    <div className="flex-shrink-0 mr-4">
                      <div className="w-12 h-12 bg-secondary-100 text-secondary-600 rounded-full flex items-center justify-center">
                        <i className="fas fa-eye text-xl"></i>
                      </div>
                    </div>
                    <div>
                      <h3 className="text-xl font-bold mb-2">Improved Visibility</h3>
                      <p className="text-slate-600">
                        Gain complete visibility into your IT infrastructure, software licenses, and support metrics.
                      </p>
                    </div>
                  </div>
                  
                  <div className="flex">
                    <div className="flex-shrink-0 mr-4">
                      <div className="w-12 h-12 bg-secondary-100 text-secondary-600 rounded-full flex items-center justify-center">
                        <i className="fas fa-tasks text-xl"></i>
                      </div>
                    </div>
                    <div>
                      <h3 className="text-xl font-bold mb-2">Streamlined Processes</h3>
                      <p className="text-slate-600">
                        Automate routine IT tasks and standardize service delivery processes across your organization.
                      </p>
                    </div>
                  </div>
                  
                  <div className="flex">
                    <div className="flex-shrink-0 mr-4">
                      <div className="w-12 h-12 bg-secondary-100 text-secondary-600 rounded-full flex items-center justify-center">
                        <i className="fas fa-heart text-xl"></i>
                      </div>
                    </div>
                    <div>
                      <h3 className="text-xl font-bold mb-2">Enhanced User Satisfaction</h3>
                      <p className="text-slate-600">
                        Provide faster, more consistent IT support to improve the user experience and satisfaction.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
              
              <div className="order-1 md:order-2 flex justify-center">
                <div className="rounded-xl overflow-hidden shadow-lg">
                  <div className="h-full w-full aspect-video bg-[url('https://images.unsplash.com/photo-1504384308090-c894fdcc538d?ixlib=rb-1.2.1&auto=format&fit=crop&w=600&q=80')] bg-cover bg-center"></div>
                </div>
              </div>
            </div>
          </div>
        </section>
        
        <CTASection />
        <ContactSection />
      </main>
      <Footer />
    </>
  );
}
